﻿using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData
    {
        private ZSBELearning _ZSBELearning = null;
        private BL.ZSBELearning.ContextParam _ContextParam = null;

        protected ZSBELearning BLP { get { return _ZSBELearning; } }
        protected BL.ZSBELearning.ContextParam ContextParam { get { return _ContextParam; } }

        public GExerciseData()
        {
            this.Exercise = new GExercise();
            this.ExerciseMeta = new GExerciseMeta();
            this.ExerciseNote = new GExerciseNote();
            this.ExerciseOwl = new GExerciseOwl();
        }

        public GExerciseData(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
        {
            _ContextParam = ContextParam;
            _ZSBELearning = BLP;
            this.Exercise = new GExercise(ContextParam);
            this.ExerciseMeta = new GExerciseMeta(ContextParam);
            this.ExerciseNote = new GExerciseNote(ContextParam);
            this.ExerciseOwl = new GExerciseOwl(ContextParam);
        }

        public GExercise Exercise { get; set; }
        public GExerciseMeta ExerciseMeta { get; set; }
        public GExerciseNote ExerciseNote { get; set; }
        public GExerciseOwl ExerciseOwl { get; set; }
        public GExerciseOwlSave ExerciseOwlSave { get; set; }

        private List<GExerciseCheck> _listGExerciseCheck = null;
        public List<GExerciseCheck> ExerciseCheck
        {
            get
            {
                if (_listGExerciseCheck == null)
                {
                    _listGExerciseCheck = new List<GExerciseCheck>();
                }
                return _listGExerciseCheck;
            }
        }

        public void SetExerciseOwlSave()
        {
            this.ExerciseOwlSave = new GExerciseOwlSave(_ContextParam);
            ContextParam.Refresh();

            BLP.BLELearning.Statistic.SaveEventCheck(ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitIn, ContextParam.ExerciseIn, ContextParam.StatisticContextID, null);

            ContextParam.Refresh();
            if (ContextParam.Group == BL.Dictionary.GroupType.Student)
            {
                if (BLP.Course.IsFinised(ContextParam))
                {
                    BLP.Statistic.Save(ContextParam);
                }
            }

            this.ExerciseMeta = new GExerciseMeta(_ContextParam);
        }
    }

}